unit Main;

//################################################
interface uses User, Kernel;
//################################################

procedure EntryProc() stdcall;

type

	Con = record
	strict private
		class var
			hIn, hOut, hWnd : HANDLE;
			CurPos : NAT32;
		class function HandleKey(VirtKey:NAT32) : BOOL32; static;
	private
		const
			ScrBuf_W = 76;
			Window_W = ScrBuf_W - 1;
			Clr_Def = $07;
		class procedure Init(); static;
		class procedure Wait(); static;
	public
		class procedure WriteA(pText:PCHAR; TxtLen:NAT32; Color:NAT32=Clr_Def); static; // Color:NAT8
		class procedure WriteW(pText:PWCHAR; TxtLen:NAT32; Color:NAT32=Clr_Def); static; // Color:NAT8
		class procedure WriteLnA(pText:PCHAR; TxtLen:NAT32; Color:NAT32=Clr_Def); static; inline; // Color:NAT8
		class procedure WriteLnW(pText:PWCHAR; TxtLen:NAT32; Color:NAT32=Clr_Def); static; inline; // Color:NAT8
		class procedure WriteLn(); static; inline;
	end;

//################################################
implementation uses Time, Utils;
//################################################

var

	sz_Caption  : array [0..13] of CHAR = 'Fix Time 1.10';
	sz_FixedFmt : array [0..16] of CHAR = 'Fixed %d time(s)';

	str_Header : array [0..39] of CHAR = 'File Time                      File Name';
	str_Separ  : array [0..73] of CHAR = '--------------------------------------------  ----------------------------';
	str_Syntax : array [0..43] of CHAR = 'Syntax: FixTime [<options>] [<file name(s)>]';
	str_Quiet  : array [0..16] of CHAR = '  /Q = Quiet mode';
	str_Press  : array [0..16] of CHAR = 'Press any key ...';

//================================================

type

	App = record
		class var
			pCmdLine : PWCHAR;
		//	CmLnSize : NAT32;
		class procedure Init(); static;
		class procedure Exit(); static;
	end;

class procedure App.Init;
var
	pwch : PWCHAR;
begin
	pwch:= GetCommandLineW();
//	CmLnSize:= wcslen(pwch) shl 1;
//	pCmdLine:= VirtualAlloc(NIL, CmLnSize, $1000, $04);
//	if (pCmdLine = NIL) then exit;
//	wcscpy(pCmdLine, pwch);
	pCmdLine:= pwch;
end;

class procedure App.Exit;
begin
//	if (pCmdLine <> NIL) then VirtualFree(pCmdLine, CmLnSize, $4000);
	ExitProcess(0);
end;

//================================================

type

	Opt = record
	private
		class var
			ArgPtrs : array [0..16383] of PWCHAR;
			cNames, iFirst : NAT32;
			fQuiet : BOOL8;
		class procedure Init(); static;
	end;

class procedure Opt.Init;
var
	pwch : PWCHAR;
begin
	cNames:= GetCmdArgsW(@ArgPtrs, sizeof(ArgPtrs), App.pCmdLine) - 1;
	iFirst:= 1;
	pwch:= ArgPtrs[1];
	if (pwch <> NIL) and (NAT32(pwch^) = $2F) then begin // U'/'
		inc(iFirst);
		dec(cNames);
		inc(NAT32(pwch), 2);
		Opt.fQuiet:= (NAT32(pwch^) = $51); // U'Q'
	end;
end;

//================================================

class function Con.HandleKey; // EAX<-VirtKey
asm
	cmp	eax, $12 // Alt
	je		@end
	mov	edx, eax
	and	eax, $20
	jz		@end
	and	edx, $0F
	xor	eax, eax
	jmp	dword [@jtab+edx*4]

// EAX=0

@20: // Space
	ret
@21: // PgUp
	or		al, $02
	jmp	@scroll
@22: // PgDown
	or		al, $03
	jmp	@scroll
@23: // End
	or		al, $07
	jmp	@scroll
@24: // Home
	or		al, $06
	jmp	@scroll
@25: // Left
	or		al, 1
	ret
@26: // Up
	jmp	@scroll // EAX = $00
@27: // Right
	or		al, 1
	ret
@28: // Down
	or		al, $01
	jmp	@scroll

.ALIGN 4
@jtab:
	DD @20,@21,@22,@23,@24,@25,@26,@27,@28,@20,@20,@20,@20,@20,@20,@20

@scroll:
	push	0; push eax; push $0115; push [hWnd]
	call	SendMessageA
	or		eax, 1
@end:
end;

class procedure Con.Init;
var
	len, h : NAT32;
	csbi : CONSOLE_SCREEN_BUFFER_INFO;
	cci : CONSOLE_CURSOR_INFO;
	cfi : CONSOLE_FONT_INFO;
	cwi : SMALL_RECT;
	ccp : COORD;
begin
	if Opt.fQuiet then exit;
	SetConsoleTitleA(@sz_Caption);
	hIn:= GetStdHandle($FFFFFFF6);
	hOut:= GetStdHandle($FFFFFFF5);
	GetConsoleScreenBufferInfo(hOut, @csbi);
	NAT32(ccp):= 0;
//	SetConsoleCursorPosition(hOut, ccp);
	len:= csbi.dwSize.X * (csbi.dwCursorPosition.Y + 1);
	FillConsoleOutputCharacterA(hOut, ' ', len, ccp, @len);
	NAT64(cci):= $20;
	SetConsoleCursorInfo(hOut, @cci);
	PNAT32(@cwi)^:= 0;
	cwi.Right:= Window_W;
	GetCurrentConsoleFont(hOut, FALSE, @cfi);
	ccp:= GetConsoleFontSize(hOut, cfi.nFont);
	h:= GetSystemMetrics(1);
	cwi.Bottom:= (h div NAT32(ccp.Y)) - (h div 38);
	SetConsoleWindowInfo(hOut, TRUE, @cwi);
	h:= cwi.Bottom + 1;
	if (Opt.cNames > h - 8) then h:= Opt.cNames + 8;
	SetConsoleScreenBufferSize(hOut, COORD(ScrBuf_W or (h shl 16)));
	SetConsoleOutputCP(GetOEMCP());
	hWnd:= FindWindowA(NIL, @sz_Caption);

	if (Opt.cNames <> 0) then begin
		CurPos:= $00010012;
		WriteLnA(@str_Header, sizeof(str_Header));
		WriteLnA(@str_Separ, sizeof(str_Separ));
	end else begin
		CurPos:= $00010001;
		WriteLnA(@str_Syntax, sizeof(str_Syntax));
		WriteLn();
		WriteLnA(@str_Quiet, sizeof(str_Quiet));
	end;
end;

class procedure Con.Wait;
var
	tmp : NAT32;
	ir : INPUT_RECORD;
begin
	if Opt.fQuiet then exit;
	Con.WriteLn();
	Con.WriteA(@str_Press, sizeof(str_Press), $09);
	Sleep(200);
	FlushConsoleInputBuffer(hIn);
	repeat
		ReadConsoleInputA(hIn, @ir, 1, @tmp);
		if (ir.EventType <> $01) then continue;
		if not ir.Event.KeyEvent.bKeyDown then continue;
		if not HandleKey(ir.Event.KeyEvent.wVirtualKeyCode) then exit;
	until FALSE;
end;

//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

class procedure Con.WriteA;
var
	buf : array [0..1023] of WORD;
	tmp : NAT32;
begin
	WriteConsoleOutputCharacterA(hOut, pText, TxtLen, COORD(CurPos), @tmp);
	if (Color <> Clr_Def) then begin
		MemSet4x(@buf, Color * $010001, (TxtLen shr 1) + 1);
		WriteConsoleOutputAttribute(hOut, @buf, TxtLen, COORD(CurPos), @tmp);
	end;
	inc(CurPos, TxtLen);
end;

class procedure Con.WriteW;
var
	buf : array [0..1023] of WORD;
	tmp : NAT32;
begin
	WriteConsoleOutputCharacterW(hOut, pText, TxtLen, COORD(CurPos), @tmp);
	if (Color <> Clr_Def) then begin
		MemSet4x(@buf, Color * $010001, (TxtLen shr 1) + 1);
		WriteConsoleOutputAttribute(hOut, @buf, TxtLen, COORD(CurPos), @tmp);
	end;
	inc(CurPos, TxtLen);
end;

class procedure Con.WriteLnA;
begin
	WriteA(pText, TxtLen, Color);
	WriteLn();
end;

class procedure Con.WriteLnW;
begin
	WriteW(pText, TxtLen, Color);
	WriteLn();
end;

class procedure Con.WriteLn;
begin
	CurPos:= (CurPos and $FFFF0000) + $00010001;
end;

//================================================

procedure PrintLine(pNewTime,pOldTime:PFILETIME; pName:PWCHAR; Color:NAT32); // pName:P(W)CHAR
const
	max_len = 26;
var
	buf : array [0..255] of CHAR;
	len : NAT32;
begin
	buf[0]:= ' ';
	if (pNewTime^.dwHighDateTime = 0) then memset(@buf, $20, 20) else TimeToStr(pNewTime, @buf[1]);
	PNAT32(@buf[20])^:= $202D3C20; // ' <- '
	TimeToStr(pOldTime, @buf[24]);
	PNAT32(@buf[43])^:= $20202020; // '    '
	Con.WriteA(@buf, 47, Color);
	len:= wcslen(pName);
	if (len > max_len) then begin
		PNAT32(NAT32(pName) + max_len * 2)^:= $25BA;
		len:= max_len + 1;
	end;
	Con.WriteLnW(pName, len, Color);
end;

procedure FixFileTimes();
label final;
var
	i, c_fixed, err_rw, clr, len, root : NAT32;
	t_new, t_old, t_sys : NAT64; // FILETIME
	fs_name : array [0..31] of CHAR;
	p_title : PWCHAR;
	precis : NAT64;
	err_gt : INT32;
	hfile : HANDLE;
	buf : array [0..511] of WCHAR;
	p : POINTER;
begin
	if (Opt.cNames = 0) then exit;
	c_fixed:= 0;
	root:= PNAT32(Opt.ArgPtrs[1])^;
	if CHAR(root shr 16) = ':' then begin
		root:= (root and $FF) or $5C3A00; // #0':\'
		p:= @root;
	end else p:= NIL;
	GetVolumeInformationA(p, NIL, 0, NIL, NIL, NIL, @fs_name, sizeof(fs_name));
	if ((PNAT32(@fs_name)^ and $FFFFFF) = $544146) then precis:= 10000000 else precis:= 9999999; // 'FAT'
	GetSystemTimeAsFileTime(@t_sys);
	i:= Opt.iFirst;
	repeat
		p:= Opt.ArgPtrs[i];
		if (p = NIL) then goto final;
		inc(i);
		GetFullPathNameW(p, sizeof(buf) div 2, @buf, @p_title);
		p:= @buf;
		if BOOL32(GetFileAttributesW(p) and $10) then continue;
		hfile:= CreateFileW(p, $00, $00, NIL, $03, $80, NULL);
		GetFileTime(hfile, NIL, NIL, @t_old);
		CloseHandle(hfile);
		hfile:= CreateFileW(p, $C0000000, $00, NIL, $03, $80, NULL);
		err_rw:= GetLastError();
		if (err_rw <> 0) then hfile:= CreateFileW(p, $80000000, $00, NIL, $03, $80, NULL);
		t_new:= 0;
		if (hfile = HANDLE(-1)) then err_gt:= gt_Unknown else err_gt:= GetIntTime(hfile, @t_new);
		if ((t_old - t_new) <= precis) then clr:= $08 else
			if (err_gt = gt_Invalid) or (t_new > t_sys) then clr:= $04 else
				if (err_rw <> 0) then clr:= $0C else
					if (err_gt = gt_Unknown) then clr:= $07
						else begin
							SetFileTime(hfile, NIL, NIL, @t_new);
							inc(c_fixed);
							clr:= $07;
						end;
		if not Opt.fQuiet then PrintLine(@t_new, @t_old, p_title, clr);
		CloseHandle(hfile);
	until FALSE;

final:
	if Opt.fQuiet then exit;
	Con.WriteLn();
	len:= wsprintfA(@buf, @sz_FixedFmt, c_fixed);
	Con.WriteLnA(@buf, len);
end;

procedure EntryProc;
begin
	App.Init();
	Opt.Init();
	Con.Init();
	FixFileTimes();
	Con.Wait();
	App.Exit();
end;

end.
